import matplotlib.pyplot as plt
import matplotlib.patches as patches

# Create a figure and axis
fig, ax = plt.subplots(figsize=(8, 10))

# Define the grid size
rows, cols = 5, 4

# Define the colors for tiles
clear_color = 'lightgreen'
white_color = 'white'
black_color = 'black'

# Define the tile painting pattern for the goal state
tile_colors = {
    (1, 0): white_color, (1, 1): black_color, (1, 2): white_color, (1, 3): black_color,
    (2, 0): black_color, (2, 1): white_color, (2, 2): black_color, (2, 3): white_color,
    (3, 0): white_color, (3, 1): black_color, (3, 2): white_color, (3, 3): black_color,
    (4, 0): black_color, (4, 1): white_color, (4, 2): black_color, (4, 3): white_color,
}

# Draw the tiles
for row in range(rows):
    for col in range(cols):
        tile_id = f'tile_{row}-{col+1}'
        color = tile_colors.get((row, col), clear_color)
        rect = patches.Rectangle((col, rows-row-1), 1, 1, linewidth=1, edgecolor='black', facecolor=color)
        ax.add_patch(rect)
        ax.text(col + 0.5, rows-row-0.5, tile_id, ha='center', va='center', fontsize=8, color='black' if color == white_color else 'white')

# Draw the robots with no constraints at the bottom
robot1_position = (0.5, -1)
robot2_position = (2.5, -1)

circle1 = patches.Circle(robot1_position, 0.3, edgecolor='black', facecolor=white_color)
ax.add_patch(circle1)
ax.text(robot1_position[0], robot1_position[1] - 0.2, 'robot1\n(no constraints)', ha='center', va='center', fontsize=8, color='black')

circle2 = patches.Circle(robot2_position, 0.3, edgecolor='black', facecolor=black_color)
ax.add_patch(circle2)
ax.text(robot2_position[0], robot2_position[1] - 0.2, 'robot2\n(no constraints)', ha='center', va='center', fontsize=8, color='white')

# Set limits and labels
ax.set_xlim(0, cols)
ax.set_ylim(-2, rows)
ax.set_xticks([])
ax.set_yticks([])

# Add legend
legend_elements = [
    patches.Patch(facecolor=clear_color, edgecolor='black', label='Unpainted Tile'),
    patches.Patch(facecolor=white_color, edgecolor='black', label='Painted Tile (White)'),
    patches.Patch(facecolor=black_color, edgecolor='black', label='Painted Tile (Black)'),
    patches.Patch(facecolor=white_color, edgecolor='black', label='Robot1 (White)'),
    patches.Patch(facecolor=black_color, edgecolor='black', label='Robot2 (Black)'),
]
ax.legend(handles=legend_elements, loc='upper right', bbox_to_anchor=(1.3, 1))

# Save the figure
plt.savefig('tiles/one_shot/goal_diagram_code/attempts/goal_diagram_attempt_6.png', bbox_inches='tight')
plt.show()